VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "BASS Add-Ons Sample"
   ClientHeight    =   3240
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   4620
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3240
   ScaleWidth      =   4620
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.Timer tmrPosition 
      Interval        =   500
      Left            =   2520
      Top             =   2640
   End
   Begin VB.PictureBox picContainer 
      BorderStyle     =   0  'Kein
      Height          =   2625
      Index           =   0
      Left            =   150
      ScaleHeight     =   2625
      ScaleWidth      =   4245
      TabIndex        =   5
      Top             =   450
      Width           =   4245
      Begin VB.ListBox lstEvents 
         Height          =   1425
         ItemData        =   "Main Form.frx":0000
         Left            =   120
         List            =   "Main Form.frx":0002
         TabIndex        =   10
         Top             =   120
         Width           =   3975
      End
      Begin VB.CommandButton cmdOpen 
         Caption         =   "&Open"
         Height          =   375
         Left            =   3120
         TabIndex        =   9
         Top             =   2160
         Width           =   975
      End
      Begin VB.CommandButton cmdStop 
         Caption         =   "&Stop"
         Height          =   375
         Left            =   1200
         TabIndex        =   8
         Top             =   2160
         Width           =   975
      End
      Begin VB.CommandButton cmdPlay 
         Caption         =   "&Play"
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   2160
         Width           =   975
      End
      Begin VB.HScrollBar hsPosition 
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   1800
         Width           =   3975
      End
   End
   Begin VB.PictureBox picContainer 
      BorderStyle     =   0  'Kein
      Height          =   2625
      Index           =   1
      Left            =   150
      ScaleHeight     =   2625
      ScaleWidth      =   4245
      TabIndex        =   3
      Top             =   450
      Width           =   4245
      Begin VB.ListBox lstTags 
         Height          =   2400
         ItemData        =   "Main Form.frx":0004
         Left            =   120
         List            =   "Main Form.frx":0006
         TabIndex        =   4
         Top             =   120
         Width           =   3975
      End
   End
   Begin VB.PictureBox picContainer 
      BorderStyle     =   0  'Kein
      Height          =   2625
      Index           =   2
      Left            =   150
      ScaleHeight     =   2625
      ScaleWidth      =   4245
      TabIndex        =   1
      Top             =   450
      Width           =   4245
      Begin VB.ListBox lstPlugins 
         Height          =   2400
         ItemData        =   "Main Form.frx":0008
         Left            =   120
         List            =   "Main Form.frx":000A
         TabIndex        =   2
         Top             =   120
         Width           =   3975
      End
   End
   Begin MSComDlg.CommonDialog cdlOpen 
      Left            =   3360
      Top             =   1080
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      Filter          =   $"Main Form.frx":000C
      Flags           =   4100
   End
   Begin ComctlLib.TabStrip tabTabs 
      Height          =   3015
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4335
      _ExtentX        =   7646
      _ExtentY        =   5318
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   3
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Play&back"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "&Tags"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab3 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "&Loaded Plugins"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * 260
    cAlternate As String * 14
End Type

Private Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Private Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Sub InitCommonControls Lib "comctl32.dll" ()
Private Declare Function lstrlen Lib "kernel32" Alias "lstrlenA" (ByVal lpString As String) As Long

Private blnScrolling As Boolean
Private lngChannel As Long
Private udtChannel As BASS_CHANNELINFO

Private Sub cmdOpen_Click()

    On Error GoTo Cancel
    cdlOpen.ShowOpen
    On Error GoTo 0

    BASS_StreamFree lngChannel
    lngChannel = BASS_StreamCreateFile(BASSFALSE, cdlOpen.filename, 0, 0, 0)

    If Not lngChannel = 0 Then
        BASS_ChannelSetSync lngChannel, BASS_SYNC_ONETIME Or BASS_SYNC_END, 0, AddressOf PlaybackStopped, 0
        BASS_ChannelGetInfo lngChannel, udtChannel
        hsPosition.max = CLng(BASS_ChannelBytes2Seconds(lngChannel, BASS_ChannelGetLength(lngChannel)))
        lstEvents.AddItem ConvertIDToName(udtChannel.ctype) & " created (" & CLng(BASS_ChannelBytes2Seconds(lngChannel, BASS_ChannelGetLength(lngChannel))) & " seconds)"
        lstEvents.AddItem "Loading tags"
        LoadTags
        lstEvents.AddItem "Tags loaded"
        lstEvents.ListIndex = lstEvents.ListCount - 1
      Else
        lstEvents.AddItem "Unable to create stream"
        lstEvents.ListIndex = lstEvents.ListCount - 1
    End If

Cancel:

End Sub

Private Sub cmdPlay_Click()

    If Not lngChannel = 0 Then
        If Not BASS_ChannelIsActive(lngChannel) = BASS_ACTIVE_PLAYING Then
            BASS_ChannelPlay lngChannel, BASSTRUE
            lstEvents.AddItem "Playback started"
            lstEvents.ListIndex = lstEvents.ListCount - 1
        End If
    End If

End Sub

Private Sub cmdStop_Click()

    If Not lngChannel = 0 Then
        If BASS_ChannelIsActive(lngChannel) = BASS_ACTIVE_PLAYING Then
            BASS_ChannelStop lngChannel
            lstEvents.AddItem "Playback stopped"
            lstEvents.ListIndex = lstEvents.ListCount - 1
        End If
    End If

End Sub

Private Function ConvertIDToName(ByVal lngID As Long) As String

    Select Case lngID
        Case &H10000
            ConvertIDToName = "Custom stream"
        Case &H10001
            ConvertIDToName = "Wave stream"
        Case &H10002
            ConvertIDToName = "Ogg Vorbis stram"
        Case &H10003
            ConvertIDToName = "MP1 stream"
        Case &H10004
            ConvertIDToName = "MP2 stream"
        Case &H10005
            ConvertIDToName = "MP3 stream"
        Case &H10006
            ConvertIDToName = "AIFF stream"
        Case &H20000
            ConvertIDToName = "MOD module"
        Case &H20001
            ConvertIDToName = "MTM module"
        Case &H20002
            ConvertIDToName = "S3M module"
        Case &H20003
            ConvertIDToName = "XM module"
        Case &H20004
            ConvertIDToName = "IT module"
        Case &H20005
            ConvertIDToName = "MO3 module"
        Case &H10200
            ConvertIDToName = "CDA stream"
        Case &H10300
            ConvertIDToName = "WMA stream"
        Case &H10900
            ConvertIDToName = "FLAC stream"
        Case &H10500
            ConvertIDToName = "WavPack stream"
        Case &H10600
            ConvertIDToName = "OptimFROG stream"
        Case &H10700
            ConvertIDToName = "Monkey's Audio stream"
        Case &H10A00
            ConvertIDToName = "Musepack stream"
        Case &H10B00
            ConvertIDToName = "AAC stream"
        Case &H10B01
            ConvertIDToName = "MP4 stream"
        Case &H10C00
            ConvertIDToName = "Speex stream"
        Case &H10E00
            ConvertIDToName = "ALAC stream"
        Case &H10F00
            ConvertIDToName = "TTA stream"
        Case &H11000
            ConvertIDToName = "AC3 stream"
        Case &H11D00
            ConvertIDToName = "DTA stream"
        Case Else
            ConvertIDToName = "Unknown format"
    End Select

End Function

Private Sub Form_Initialize()

    InitCommonControls

End Sub

Private Sub Form_Load()

  Dim lngAdditionalFilesAvailable As Long
  Dim lngCounter As Long
  Dim lngFile As Long
  Dim lngPlugin As Long
  Dim udtFileAttributes As WIN32_FIND_DATA
  Dim udtPluginInformation As BASS_PLUGININFO

    If Not HiWord(BASS_GetVersion) = BASSVERSION Then
        MsgBox "BASS 2.3 was not found.", vbCritical, "Error"
        Unload Me
        Exit Sub
      Else
        lstEvents.AddItem "BASS 2.3 loaded"
        lstEvents.ListIndex = lstEvents.ListCount - 1
    End If

    If BASS_Init(-1, 44100, 0, Me.hWnd, 0) = 0 Then
        MsgBox "Cannot initialize playback device.", vbCritical, "Error"
        Unload Me
        Exit Sub
      Else
        lstEvents.AddItem "Using " & VBStrFromAnsiPtr(BASS_GetDeviceDescription(BASS_GetDevice())) & " @ 44100 Hz"
        lstEvents.ListIndex = lstEvents.ListCount - 1
    End If

    lstEvents.AddItem "Loading plugins"
    lstEvents.ListIndex = lstEvents.ListCount - 1

    lngFile = FindFirstFile("bass*.dll", udtFileAttributes)
    If Not lngFile = -1 Then
        Do
            If CBool(udtFileAttributes.dwFileAttributes And vbDirectory) = False Then
                lngPlugin = BASS_PluginLoad(Mid$(udtFileAttributes.cFileName, 1, lstrlen(udtFileAttributes.cFileName)), 0)
                If lngPlugin Then
                    udtPluginInformation = BASS_PluginGetInfo(lngPlugin)
                    For lngCounter = 0 To udtPluginInformation.formatc - 1
                        cdlOpen.Filter = cdlOpen.Filter & "|" & VBStrFromAnsiPtr(BASS_PluginGetInfoFormat(lngPlugin, lngCounter).name) & " (" & VBStrFromAnsiPtr(BASS_PluginGetInfoFormat(lngPlugin, lngCounter).exts) & ")|" & VBStrFromAnsiPtr(BASS_PluginGetInfoFormat(lngPlugin, lngCounter).exts)
                    Next
                    lstPlugins.AddItem Mid$(udtFileAttributes.cFileName, 1, lstrlen(udtFileAttributes.cFileName))
                    lstEvents.ListIndex = lstEvents.ListCount - 1
                End If
            End If
            lngAdditionalFilesAvailable = FindNextFile(lngFile, udtFileAttributes)
            DoEvents
        Loop Until lngAdditionalFilesAvailable = 0
        FindClose lngFile
    End If

    lstEvents.AddItem "Loaded " & lstPlugins.ListCount & " plugins"
    lstEvents.ListIndex = lstEvents.ListCount - 1

End Sub

Private Sub Form_Unload(Cancel As Integer)

    BASS_Free
    BASS_PluginFree 0

End Sub

Private Sub hsPosition_Change()

    If Not lngChannel = 0 Then
        If blnScrolling = True Then
            BASS_ChannelSetPosition lngChannel, BASS_ChannelSeconds2Bytes(lngChannel, hsPosition.value)
            blnScrolling = False
        End If
    End If

End Sub

Private Sub LoadTags()

  Dim lngTagPointer As Long
  Dim strTagField As String

    lstTags.Clear

    lngTagPointer = BASS_ChannelGetTags(lngChannel, 0)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ ID3v1 Metadata ] -----"
        lstTags.AddItem "Data found, but skipping processing"
    End If
    
    lngTagPointer = 0
    
    lngTagPointer = BASS_ChannelGetTags(lngChannel, 1)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ ID3v2 Metadata ] -----"
        lstTags.AddItem "Data found, but skipping processing"
    End If
    
    lngTagPointer = 0

    lngTagPointer = BASS_ChannelGetTags(lngChannel, 6)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ APEv2 Metadata ] -----"
        Do
            strTagField = VBStrFromAnsiPtr(lngTagPointer)
            lngTagPointer = lngTagPointer + Len(strTagField) + 1
            If Not strTagField = vbNullString Then
                lstTags.AddItem strTagField
            End If
        Loop While Not strTagField = vbNullString
    End If

    lngTagPointer = 0

    lngTagPointer = BASS_ChannelGetTags(lngChannel, 2)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ Vorbis Metadata ] -----"
        Do
            strTagField = VBStrFromAnsiPtr(lngTagPointer)
            lngTagPointer = lngTagPointer + Len(strTagField) + 1
            If Not strTagField = vbNullString Then
                lstTags.AddItem strTagField
            End If
        Loop While Not strTagField = vbNullString
    End If

    lngTagPointer = 0

    lngTagPointer = BASS_ChannelGetTags(lngChannel, 7)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ MP4/iTunes Metadata ] -----"
        Do
            strTagField = VBStrFromAnsiPtr(lngTagPointer)
            lngTagPointer = lngTagPointer + Len(strTagField) + 1
            If Not strTagField = vbNullString Then
                lstTags.AddItem strTagField
            End If
        Loop While Not strTagField = vbNullString
    End If

    lngTagPointer = 0

    lngTagPointer = BASS_ChannelGetTags(lngChannel, 8)
    If Not lngTagPointer = 0 Then
        lstTags.AddItem "----- [ WMA Metadata ] -----"
        Do
            strTagField = VBStrFromAnsiPtr(lngTagPointer)
            lngTagPointer = lngTagPointer + Len(strTagField) + 1
            If Not strTagField = vbNullString Then
                lstTags.AddItem strTagField
            End If
        Loop While Not strTagField = vbNullString
    End If

End Sub

Private Sub hsPosition_Scroll()

    blnScrolling = True

End Sub

Private Sub tabTabs_Click()

  Dim lngCounter As Long

    For lngCounter = 1 To 3
        If tabTabs.SelectedItem.index = lngCounter Then
            picContainer(lngCounter - 1).Visible = True
          Else
            picContainer(lngCounter - 1).Visible = False
        End If
    Next

End Sub

Private Sub tmrPosition_Timer()

    On Error Resume Next

    If Not lngChannel = 0 Then
        If BASS_ChannelIsActive(lngChannel) = BASS_ACTIVE_PLAYING Then
            If blnScrolling = False Then
                hsPosition.value = CLng(BASS_ChannelBytes2Seconds(lngChannel, BASS_ChannelGetPosition(lngChannel)))
            End If
        End If
    End If

    On Error GoTo 0

End Sub
